# AI Visibility Tracker - Deployment Guide

## Quick Start

### 1. Upload & Extract
```bash
# Upload the ZIP file to your web server
# Extract to your web directory
unzip ai-visibility-tracker.zip

# Set web root to the public directory
# Example for Apache: DocumentRoot /var/www/ai-visibility-tracker/public
```

### 2. Set Permissions
```bash
chmod 755 logs/
chmod 755 public/uploads/
```

### 3. Run Installer
- Visit: `https://yourdomain.com/install`
- Follow the step-by-step wizard
- Provide database credentials, site settings, and admin account
- The installer will create the database and configuration automatically

### 4. Complete Setup
```bash
# Delete installer for security
rm -rf install/

# Set proper permissions
chmod 644 config.php
```

### 5. Start Queue Worker
```bash
# Run in background
nohup php worker.php &

# Or use supervisor/systemd (see below)
```

## Production Deployment

### Server Requirements
- PHP 8.0+ with PDO MySQL, cURL, JSON extensions
- MySQL 5.7+ or MariaDB 10.3+
- Apache with mod_rewrite or Nginx
- 512MB+ RAM, 1GB+ storage

### Nginx Configuration
```nginx
server {
    listen 80;
    server_name yourdomain.com;
    return 301 https://$server_name$request_uri;
}

server {
    listen 443 ssl http2;
    server_name yourdomain.com;
    
    root /var/www/ai-visibility-tracker/public;
    index index.php;
    
    ssl_certificate /path/to/cert.pem;
    ssl_certificate_key /path/to/key.pem;
    
    # Security headers
    add_header X-Frame-Options DENY;
    add_header X-Content-Type-Options nosniff;
    add_header X-XSS-Protection "1; mode=block";
    add_header Strict-Transport-Security "max-age=31536000; includeSubDomains";
    
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.0-fpm.sock;
        fastcgi_index index.php;
        include fastcgi_params;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
    }
    
    location ~ /\.ht {
        deny all;
    }
}
```

### Supervisor Configuration
```ini
# /etc/supervisor/conf.d/ai-visibility-worker.conf
[program:ai-visibility-worker]
process_name=%(program_name)s_%(process_num)02d
command=/usr/bin/php /var/www/ai-visibility-tracker/worker.php %(process_num)02d
autostart=true
autorestart=true
user=www-data
numprocs=2
redirect_stderr=true
stdout_logfile=/var/log/ai-visibility-worker.log
```

Start workers:
```bash
sudo supervisorctl reread
sudo supervisorctl update
sudo supervisorctl start ai-visibility-worker:*
```

### Cron Jobs
```bash
# Add to crontab
0 * * * * /usr/bin/php /var/www/ai-visibility-tracker/cron.php
```

### Database Optimization
```sql
-- Add performance indexes
CREATE INDEX idx_analytics_composite ON analytics(website_id, model_id, recorded_at);
CREATE INDEX idx_job_queue_composite ON job_queue(status, priority, created_at);
CREATE INDEX idx_ai_requests_composite ON ai_requests(website_id, model_id, created_at);
```

### Security Hardening
```bash
# Set secure permissions
chmod 600 config.php
chmod 644 public/.htaccess

# Remove unnecessary files
rm -rf deploy.php
rm -rf config.example.php
```

### Monitoring
- Check logs in `/logs/` directory
- Monitor queue status in admin dashboard
- Set up alerts for failed jobs
- Monitor disk space for logs

## Troubleshooting

### Installation Issues
- Check PHP version: `php -v`
- Verify database connection
- Check file permissions
- Review installer logs

### Queue Worker Issues
- Check worker logs: `tail -f /var/log/ai-visibility-worker.log`
- Verify database connectivity
- Check for rate limit errors
- Ensure OpenRouter API key is valid

### Performance Issues
- Enable OPcache in PHP
- Add database indexes
- Scale queue workers
- Monitor memory usage

## Support

For issues and questions:
- Check the README.md file
- Review application logs
- Check admin dashboard for system status
- Verify configuration settings