<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title ?? 'AI Visibility Tracker'); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($meta_description ?? 'Track your AI visibility across major AI models'); ?>">
    <meta name="csrf-token" content="<?php echo $csrf_token ?? ''; ?>">
    <link rel="stylesheet" href="/css/app.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <header class="header">
        <div class="container">
            <nav class="nav">
                <div class="nav-brand">
                    <a href="/" class="logo">AI Visibility Tracker</a>
                </div>
                
                <div class="nav-menu">
                    <?php if ($auth->isLoggedIn()): ?>
                        <a href="/dashboard" class="nav-link">Dashboard</a>
                        <a href="/dashboard/websites" class="nav-link">Websites</a>
                        <a href="/dashboard/analytics" class="nav-link">Analytics</a>
                        
                        <?php if ($auth->isAdmin()): ?>
                            <a href="/admin" class="nav-link">Admin</a>
                        <?php endif; ?>
                        
                        <div class="nav-dropdown">
                            <button class="nav-dropdown-toggle">
                                <?php echo htmlspecialchars($auth->getUserEmail()); ?>
                            </button>
                            <div class="nav-dropdown-menu">
                                <a href="/dashboard/settings" class="nav-dropdown-link">Settings</a>
                                <a href="/logout" class="nav-dropdown-link">Logout</a>
                            </div>
                        </div>
                    <?php else: ?>
                        <a href="/features" class="nav-link">Features</a>
                        <a href="/pricing" class="nav-link">Pricing</a>
                        <a href="/about" class="nav-link">About</a>
                        <a href="/login" class="nav-link">Login</a>
                        <a href="/register" class="btn btn-primary">Get Started</a>
                    <?php endif; ?>
                </div>
                
                <button class="nav-toggle">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
            </nav>
        </div>
    </header>

    <main class="main">
        <?php echo $content; ?>
    </main>

    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3>AI Visibility Tracker</h3>
                    <p>Monitor how AI models perceive and recommend your website across major AI platforms.</p>
                </div>
                
                <div class="footer-section">
                    <h4>Product</h4>
                    <ul>
                        <li><a href="/features">Features</a></li>
                        <li><a href="/pricing">Pricing</a></li>
                        <li><a href="/about">About</a></li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h4>Resources</h4>
                    <ul>
                        <li><a href="/docs">Documentation</a></li>
                        <li><a href="/api">API</a></li>
                        <li><a href="/contact">Contact</a></li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h4>Legal</h4>
                    <ul>
                        <li><a href="/terms">Terms of Service</a></li>
                        <li><a href="/privacy">Privacy Policy</a></li>
                    </ul>
                </div>
            </div>
            
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> AI Visibility Tracker. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script src="/js/app.js"></script>
    
    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="flash-message flash-success">
            <?php echo htmlspecialchars($_SESSION['flash_message']); ?>
        </div>
        <?php unset($_SESSION['flash_message']); ?>
    <?php endif; ?>
    
    <?php if (isset($_SESSION['flash_error'])): ?>
        <div class="flash-message flash-error">
            <?php echo htmlspecialchars($_SESSION['flash_error']); ?>
        </div>
        <?php unset($_SESSION['flash_error']); ?>
    <?php endif; ?>
</body>
</html>