<?php
/**
 * AI Visibility Tracker - Configuration Example
 * Copy this file to config.php and update with your values
 */

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'ai_visibility_tracker');
define('DB_USER', 'username');
define('DB_PASS', 'password');

// Application Configuration
define('BASE_URL', 'https://yourdomain.com');
define('SITE_NAME', 'AI Visibility Tracker');

// Security Configuration
define('SECRET_KEY', 'your-very-secure-secret-key-here-change-this');
define('DEBUG_MODE', false);
define('LOG_LEVEL', 6); // 0=EMERGENCY, 7=DEBUG

// Email Configuration
define('ADMIN_EMAIL', 'admin@yourdomain.com');
define('EMAIL_FROM', 'noreply@yourdomain.com');

// Rate Limiting
define('MAX_REQUESTS_PER_MINUTE', 60);
define('MAX_REQUESTS_PER_HOUR', 1000);

// Queue Configuration
define('QUEUE_WORKERS', 1);
define('JOB_TIMEOUT', 300);

// OpenRouter API Configuration
define('OPENROUTER_API_KEY', 'your-openrouter-api-key-here');

// Session Configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);
ini_set('session.cookie_samesite', 'Strict');

// Timezone
date_default_timezone_set('UTC');

// Load core classes
require_once dirname(__DIR__) . '/core/Logger.php';
require_once dirname(__DIR__) . '/core/Database.php';
require_once dirname(__DIR__) . '/core/Auth.php';
require_once dirname(__DIR__) . '/core/Queue.php';