<?php
/**
 * AI Visibility Tracker - Deployment Script
 * 
 * This script packages the application for deployment
 */

$sourceDir = __DIR__;
$targetDir = $sourceDir . '/dist';
$zipFile = $sourceDir . '/ai-visibility-tracker.zip';

// Clean up previous builds
if (file_exists($targetDir)) {
    removeDirectory($targetDir);
}

if (file_exists($zipFile)) {
    unlink($zipFile);
}

// Create directories
mkdir($targetDir, 0755, true);
mkdir($targetDir . '/app', 0755, true);
mkdir($targetDir . '/core', 0755, true);
mkdir($targetDir . '/install', 0755, true);
mkdir($targetDir . '/public', 0755, true);
mkdir($targetDir . '/logs', 0755, true);

// Copy core files
copy($sourceDir . '/public/index.php', $targetDir . '/public/index.php');
copy($sourceDir . '/public/.htaccess', $targetDir . '/public/.htaccess');
copy($sourceDir . '/worker.php', $targetDir . '/worker.php');
copy($sourceDir . '/cron.php', $targetDir . '/cron.php');
copy($sourceDir . '/README.md', $targetDir . '/README.md');

// Copy core classes
copy($sourceDir . '/core/Database.php', $targetDir . '/core/Database.php');
copy($sourceDir . '/core/Auth.php', $targetDir . '/core/Auth.php');
copy($sourceDir . '/core/Queue.php', $targetDir . '/core/Queue.php');
copy($sourceDir . '/core/Logger.php', $targetDir . '/core/Logger.php');

// Copy installer
copy($sourceDir . '/install/index.php', $targetDir . '/install/index.php');
copy($sourceDir . '/install/schema.sql', $targetDir . '/install/schema.sql');

// Copy app directory
copyDirectory($sourceDir . '/app', $targetDir . '/app');

// Copy public assets
copyDirectory($sourceDir . '/public/css', $targetDir . '/public/css');
copyDirectory($sourceDir . '/public/js', $targetDir . '/public/js');

// Create empty config file
touch($targetDir . '/config.php');

// Set permissions
chmod($targetDir . '/logs', 0755);
chmod($targetDir . '/public/uploads', 0755);
chmod($targetDir . '/config.php', 0644);

// Create deployment package
$zip = new ZipArchive();
if ($zip->open($zipFile, ZipArchive::CREATE) === true) {
    addDirectoryToZip($zip, $targetDir, 'ai-visibility-tracker');
    $zip->close();
    echo "Deployment package created: $zipFile\n";
} else {
    die("Failed to create ZIP file\n");
}

// Clean up temporary directory
removeDirectory($targetDir);

echo "Deployment complete!\n";
echo "Package: $zipFile\n";

// Helper functions
function copyDirectory($source, $target) {
    $dir = opendir($source);
    @mkdir($target);
    
    while (($file = readdir($dir)) !== false) {
        if ($file == '.' || $file == '..') continue;
        
        $sourcePath = $source . '/' . $file;
        $targetPath = $target . '/' . $file;
        
        if (is_dir($sourcePath)) {
            copyDirectory($sourcePath, $targetPath);
        } else {
            copy($sourcePath, $targetPath);
        }
    }
    
    closedir($dir);
}

function removeDirectory($dir) {
    if (!is_dir($dir)) return;
    
    $files = array_diff(scandir($dir), array('.', '..'));
    
    foreach ($files as $file) {
        $path = $dir . '/' . $file;
        is_dir($path) ? removeDirectory($path) : unlink($path);
    }
    
    rmdir($dir);
}

function addDirectoryToZip($zip, $dir, $baseDir = '') {
    $files = array_diff(scandir($dir), array('.', '..'));
    
    foreach ($files as $file) {
        $path = $dir . '/' . $file;
        $zipPath = $baseDir . '/' . $file;
        
        if (is_dir($path)) {
            $zip->addEmptyDir($zipPath);
            addDirectoryToZip($zip, $path, $zipPath);
        } else {
            $zip->addFile($path, $zipPath);
        }
    }
}