<?php

class HomeController extends BaseController
{
    public function index()
    {
        $stats = $this->getPublicStats();
        
        echo $this->renderLayout('home.index', [
            'page_title' => 'AI Visibility Tracker - Track Your AI Presence',
            'meta_description' => 'Monitor how AI models perceive and recommend your website across major AI platforms.',
            'stats' => $stats
        ]);
    }

    public function features()
    {
        echo $this->renderLayout('home.features', [
            'page_title' => 'Features - AI Visibility Tracker',
            'meta_description' => 'Discover how AI Visibility Tracker helps you monitor and improve your AI presence.'
        ]);
    }

    public function pricing()
    {
        echo $this->renderLayout('home.pricing', [
            'page_title' => 'Pricing - AI Visibility Tracker',
            'meta_description' => 'Choose the perfect plan for monitoring your AI visibility.'
        ]);
    }

    public function about()
    {
        echo $this->renderLayout('home.about', [
            'page_title' => 'About - AI Visibility Tracker',
            'meta_description' => 'Learn about AI Visibility Tracker and our mission to help businesses understand their AI presence.'
        ]);
    }

    public function contact()
    {
        echo $this->renderLayout('home.contact', [
            'page_title' => 'Contact - AI Visibility Tracker',
            'meta_description' => 'Get in touch with the AI Visibility Tracker team.'
        ]);
    }

    public function terms()
    {
        echo $this->renderLayout('home.terms', [
            'page_title' => 'Terms of Service - AI Visibility Tracker',
            'meta_description' => 'Terms of Service for AI Visibility Tracker.'
        ]);
    }

    public function privacy()
    {
        echo $this->renderLayout('home.privacy', [
            'page_title' => 'Privacy Policy - AI Visibility Tracker',
            'meta_description' => 'Privacy Policy for AI Visibility Tracker.'
        ]);
    }

    private function getPublicStats()
    {
        return $this->db->fetch(
            "SELECT 
                COUNT(DISTINCT w.id) as total_websites,
                COUNT(DISTINCT u.id) as total_users,
                AVG(w.visibility_score) as avg_visibility_score,
                COUNT(CASE WHEN w.last_scan_at > DATE_SUB(NOW(), INTERVAL 24 HOUR) THEN 1 END) as recently_scanned
             FROM websites w
             JOIN users u ON w.user_id = u.id
             WHERE w.is_active = 1 AND u.is_active = 1"
        );
    }
}