<div class="admin-container">
    <div class="admin-header">
        <h1>Admin Dashboard</h1>
        <p>System overview and management</p>
    </div>
    
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">👥</div>
            <div class="stat-content">
                <div class="stat-number"><?php echo $user_stats['total_users'] ?? 0; ?></div>
                <div class="stat-label">Total Users</div>
                <div class="stat-detail"><?php echo $user_stats['active_users'] ?? 0; ?> active</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">🌐</div>
            <div class="stat-content">
                <div class="stat-number"><?php echo $website_stats['total_websites'] ?? 0; ?></div>
                <div class="stat-label">Total Websites</div>
                <div class="stat-detail"><?php echo $website_stats['scanned_websites'] ?? 0; ?> scanned</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">📊</div>
            <div class="stat-content">
                <div class="stat-number"><?php echo number_format($website_stats['avg_visibility_score'] ?? 0, 1); ?>%</div>
                <div class="stat-label">Avg Visibility</div>
                <div class="stat-detail">Global average</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">⚡</div>
            <div class="stat-content">
                <div class="stat-number"><?php echo $queue_stats['pending'] ?? 0; ?></div>
                <div class="stat-label">Queue Jobs</div>
                <div class="stat-detail"><?php echo $queue_stats['processing'] ?? 0; ?> processing</div>
            </div>
        </div>
    </div>
    
    <div class="admin-grid">
        <div class="admin-section">
            <div class="section-header">
                <h2>Recent Users</h2>
                <a href="/admin/users" class="btn btn-sm btn-outline">View All</a>
            </div>
            
            <div class="user-list">
                <?php foreach ($recent_users as $user): ?>
                    <div class="user-item">
                        <div class="user-info">
                            <div class="user-email"><?php echo htmlspecialchars($user['email']); ?></div>
                            <div class="user-meta">
                                <span class="role-badge role-<?php echo $user['role']; ?>"><?php echo ucfirst($user['role']); ?></span>
                                <?php if (!$user['is_active']): ?>
                                    <span class="status-badge status-suspended">Suspended</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="user-date"><?php echo date('M j, Y', strtotime($user['created_at'])); ?></div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <div class="admin-section">
            <div class="section-header">
                <h2>Recent Websites</h2>
                <a href="/admin/websites" class="btn btn-sm btn-outline">View All</a>
            </div>
            
            <div class="website-list">
                <?php foreach ($recent_websites as $website): ?>
                    <div class="website-item">
                        <div class="website-info">
                            <div class="website-name">
                                <a href="/admin/websites/<?php echo $website['id']; ?>">
                                    <?php echo htmlspecialchars($website['name']); ?>
                                </a>
                            </div>
                            <div class="website-meta">
                                <span class="user-email"><?php echo htmlspecialchars($website['user_email']); ?></span>
                                <?php if (!$website['is_active']): ?>
                                    <span class="status-badge status-inactive">Inactive</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="website-score">
                            <?php if ($website['visibility_score'] > 0): ?>
                                <span class="score-badge"><?php echo $website['visibility_score']; ?>%</span>
                            <?php else: ?>
                                <span class="score-badge score-none">—</span>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    
    <div class="admin-grid">
        <div class="admin-section">
            <div class="section-header">
                <h2>Quick Actions</h2>
            </div>
            
            <div class="action-grid">
                <a href="/admin/users/add" class="action-card">
                    <div class="action-icon">➕</div>
                    <div class="action-title">Add User</div>
                </a>
                
                <a href="/admin/models" class="action-card">
                    <div class="action-icon">🤖</div>
                    <div class="action-title">AI Models</div>
                </a>
                
                <a href="/admin/prompts" class="action-card">
                    <div class="action-icon">📝</div>
                    <div class="action-title">Prompts</div>
                </a>
                
                <a href="/admin/settings" class="action-card">
                    <div class="action-icon">⚙️</div>
                    <div class="action-title">Settings</div>
                </a>
                
                <a href="/admin/logs" class="action-card">
                    <div class="action-icon">📋</div>
                    <div class="action-title">System Logs</div>
                </a>
            </div>
        </div>
        
        <div class="admin-section">
            <div class="section-header">
                <h2>System Status</h2>
            </div>
            
            <div class="status-list">
                <div class="status-item">
                    <span class="status-label">Database</span>
                    <span class="status-indicator status-ok">Connected</span>
                </div>
                
                <div class="status-item">
                    <span class="status-label">Queue Worker</span>
                    <span class="status-indicator status-ok">Running</span>
                </div>
                
                <div class="status-item">
                    <span class="status-label">OpenRouter API</span>
                    <span class="status-indicator status-ok">Active</span>
                </div>
                
                <div class="status-item">
                    <span class="status-label">Log Storage</span>
                    <span class="status-indicator status-ok">Writable</span>
                </div>
                
                <div class="status-item">
                    <span class="status-label">Debug Mode</span>
                    <span class="status-indicator status-<?php echo DEBUG_MODE ? 'warning' : 'ok'; ?>">
                        <?php echo DEBUG_MODE ? 'Enabled' : 'Disabled'; ?>
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>