<div class="hero">
    <div class="container">
        <div class="hero-content">
            <h1>Track Your AI Visibility</h1>
            <p>Monitor how AI models perceive and recommend your website across major AI platforms including GPT-4, Claude, and Gemini.</p>
            <div class="hero-buttons">
                <?php if (!$auth->isLoggedIn()): ?>
                    <a href="/register" class="btn btn-primary btn-lg">Start Free Trial</a>
                    <a href="/features" class="btn btn-outline btn-lg">Learn More</a>
                <?php else: ?>
                    <a href="/dashboard" class="btn btn-primary btn-lg">Go to Dashboard</a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<div class="stats">
    <div class="container">
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-number"><?php echo number_format($stats['total_websites'] ?? 0); ?></div>
                <div class="stat-label">Websites Tracked</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo number_format($stats['total_users'] ?? 0); ?></div>
                <div class="stat-label">Active Users</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo number_format($stats['avg_visibility_score'] ?? 0, 1); ?>%</div>
                <div class="stat-label">Avg Visibility Score</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo number_format($stats['recently_scanned'] ?? 0); ?></div>
                <div class="stat-label">Scanned Today</div>
            </div>
        </div>
    </div>
</div>

<div class="features">
    <div class="container">
        <h2 class="text-center">Powerful Features for AI Visibility</h2>
        <p class="text-center">Everything you need to understand and improve your AI presence</p>
        
        <div class="features-grid">
            <div class="feature-card">
                <div class="feature-icon">🤖</div>
                <h3>Multi-Model Testing</h3>
                <p>Test your website's visibility across GPT-4, Claude 3, Gemini Pro, and more through OpenRouter API.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">📊</div>
                <h3>Detailed Analytics</h3>
                <p>Track visibility scores, mention detection, recommendation rates, and keyword associations over time.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">⚡</div>
                <h3>Queue System</h3>
                <p>High-performance job queue ensures reliable processing of AI requests with automatic retry logic.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">🎯</div>
                <h3>Question Association</h3>
                <p>Discover what questions lead AI models to recommend your website and understand user intent.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">🔍</div>
                <h3>Recommendation Tracking</h3>
                <p>Monitor when AI models recommend your site and analyze the context and reasoning behind recommendations.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">📈</div>
                <h3>Visibility Index</h3>
                <p>Get a comprehensive AI Visibility Index score (0-100) based on recognition across all tested models.</p>
            </div>
        </div>
    </div>
</div>

<div class="cta-section">
    <div class="container">
        <div class="cta-content">
            <h2>Ready to Track Your AI Visibility?</h2>
            <p>Join thousands of businesses monitoring their AI presence</p>
            <?php if (!$auth->isLoggedIn()): ?>
                <a href="/register" class="btn btn-primary btn-lg">Get Started Free</a>
            <?php else: ?>
                <a href="/dashboard" class="btn btn-primary btn-lg">View Dashboard</a>
            <?php endif; ?>
        </div>
    </div>
</div>